/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1873", name="\"static final\" arrays should be \"private\"", priority=Priority.CRITICAL, tags={"cwe", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="API_ABUSE")
@SqaleConstantRemediation(value="15min")
public class StaticFinalArrayNotPrivateCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        if (variableTree.type().is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE}) && StaticFinalArrayNotPrivateCheck.isStaticFinalNotPrivate(variableTree)) {
            this.addIssue(tree, "Make this array \"private\".");
        }
    }

    private static boolean isStaticFinalNotPrivate(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.isStatic(variableTree) && StaticFinalArrayNotPrivateCheck.isFinal(variableTree) && !StaticFinalArrayNotPrivateCheck.isPrivate(variableTree);
    }

    private static boolean isStatic(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.hasModifier(variableTree, Modifier.STATIC);
    }

    private static boolean isFinal(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.hasModifier(variableTree, Modifier.FINAL);
    }

    private static boolean isPrivate(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.hasModifier(variableTree, Modifier.PRIVATE);
    }

    private static boolean hasModifier(VariableTree variableTree, Modifier modifier) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)modifier);
    }
}

