/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.SerializableContract;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

@Rule(key="UnusedProtectedMethod", name="Unused protected methods should be removed", priority=Priority.MAJOR, tags={"unused"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class UnusedProtectedMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (UnusedProtectedMethodCheck.isUnusedNonOverridenProtectedMethod(asmMethod) && !this.asmClass.isAbstract() && !SerializableContract.methodMatch(asmMethod)) {
            CheckMessage message = new CheckMessage((Object)this, "Protected method '" + asmMethod.getName() + "(...)' is never used.", new Object[0]);
            int line = this.getMethodLineNumber(asmMethod);
            if (line > 0) {
                message.setLine(line);
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }

    private static boolean isUnusedNonOverridenProtectedMethod(AsmMethod asmMethod) {
        return !asmMethod.isUsed() && asmMethod.isProtected() && !asmMethod.isInherited();
    }
}

