/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.symexec.ExecutionState;
import org.sonar.java.symexec.SymbolicBooleanConstraint;
import org.sonar.java.symexec.SymbolicEvaluator;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2583", name="Conditions should not unconditionally evaluate to \"TRUE\" or to \"FALSE\"", priority=Priority.BLOCKER, tags={"bug", "cwe", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class UselessConditionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CONSTRUCTOR, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        SymbolicEvaluator engine = new SymbolicEvaluator();
        for (Map.Entry<Tree, SymbolicBooleanConstraint> entry : engine.evaluateMethod(this.context, new ExecutionState(), (MethodTree)tree).entrySet()) {
            switch (entry.getValue()) {
                case FALSE: {
                    this.raiseIssue(entry.getKey(), "false");
                    break;
                }
                case TRUE: {
                    this.raiseIssue(entry.getKey(), "true");
                    break;
                }
            }
        }
    }

    private void raiseIssue(Tree tree, String value) {
        this.addIssue(tree, String.format("Change this condition so that it does not always evaluate to \"%s\"", value));
    }
}

