/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.symexecengine;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.java.symexecengine.ExecutionState;
import org.sonar.java.symexecengine.State;
import org.sonar.java.symexecengine.SymbolicExecutionCheck;
import org.sonar.java.symexecengine.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class DataFlowVisitor
extends BaseTreeVisitor {
    private final SymbolicExecutionCheck check;
    private ExecutionState executionState;

    public static void analyze(MethodTree method, SymbolicExecutionCheck check) {
        BlockTree block = method.block();
        if (block != null) {
            ExecutionState executionState = new ExecutionState();
            ArrayList<SymbolicValue> arguments = new ArrayList<SymbolicValue>();
            for (VariableTree methodParameter : method.parameters()) {
                executionState.defineSymbol(methodParameter.symbol());
                arguments.add(executionState.createValueForSymbol(methodParameter.symbol(), (Tree)methodParameter));
            }
            check.initialize(executionState, method, arguments);
            block.accept((TreeVisitor)new DataFlowVisitor(executionState, method, check));
            for (State state : executionState.getStatesOfCurrentExecutionState()) {
                check.onValueUnreachable(executionState, state);
            }
        }
    }

    private DataFlowVisitor(ExecutionState executionState, MethodTree analyzedMethod, SymbolicExecutionCheck check) {
        this.check = check;
        this.executionState = executionState;
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        this.executionState.defineSymbol(tree.symbol());
        this.executionState.createValueForSymbol(tree.symbol(), (Tree)tree);
        if (tree.initializer() != null) {
            this.check.onAssignment(this.executionState, (Tree)tree, tree.symbol(), tree.initializer());
        }
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        Symbol symbol = this.getSymbol(tree.variable());
        if (symbol != null) {
            this.executionState.createValueForSymbol(symbol, (Tree)tree.expression());
            this.check.onAssignment(this.executionState, (Tree)tree, symbol, tree.expression());
        }
    }

    @CheckForNull
    protected Symbol getSymbol(ExpressionTree variable) {
        if (!variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT})) {
            return null;
        }
        IdentifierTree identifier = variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)variable : ((MemberSelectExpressionTree)variable).identifier();
        return identifier.symbol();
    }

    public void visitNewClass(NewClassTree tree) {
        this.check.onExecutableElementInvocation(this.executionState, (Tree)tree, (List<ExpressionTree>)tree.arguments());
    }

    public void visitClass(ClassTree tree) {
    }

    public void visitTryStatement(TryStatementTree tree) {
        ExecutionState blockES;
        this.executionState = blockES = new ExecutionState(this.executionState);
        this.scan((Tree)tree.block());
        this.scan(tree.resources());
        for (VariableTree resource : tree.resources()) {
            for (SymbolicValue value : this.executionState.getValues(resource.symbol())) {
                this.check.onTryResourceClosed(this.executionState, value);
            }
        }
        for (CatchTree catchTree : tree.catches()) {
            this.executionState = new ExecutionState(blockES.parent);
            this.scan((Tree)catchTree.block());
            blockES.merge(this.executionState);
        }
        if (tree.finallyBlock() != null) {
            this.executionState = new ExecutionState(blockES.parent);
            this.scan((Tree)tree.finallyBlock());
            this.reportUnreachable(this.executionState.getStatesOfCurrentExecutionState());
            this.executionState = blockES.parent.overrideBy(blockES.overrideBy(this.executionState));
        } else {
            this.reportUnreachable(blockES.getStatesOfCurrentExecutionState());
            this.executionState = blockES.restoreParent();
        }
    }

    public void visitIfStatement(IfStatementTree tree) {
        ExecutionState thenES;
        this.scan((Tree)tree.condition());
        this.executionState = thenES = new ExecutionState(this.executionState);
        this.scan((Tree)tree.thenStatement());
        if (tree.elseStatement() == null) {
            this.reportUnreachable(thenES.getStatesOfCurrentExecutionState());
            this.executionState = thenES.restoreParent();
        } else {
            ExecutionState elseES;
            this.executionState = elseES = new ExecutionState(thenES.parent);
            this.scan((Tree)tree.elseStatement());
            this.reportUnreachable(elseES.getStatesOfCurrentExecutionState());
            this.executionState = thenES.parent.overrideBy(thenES.merge(elseES));
        }
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan((Tree)tree.expression());
        ExecutionState resultingES = new ExecutionState(this.executionState);
        this.executionState = new ExecutionState(this.executionState);
        for (CaseGroupTree caseGroupTree : tree.cases()) {
            for (StatementTree statement : caseGroupTree.body()) {
                if (DataFlowVisitor.isBreakOrReturnStatement(statement)) {
                    resultingES = this.executionState.merge(resultingES);
                    this.executionState = new ExecutionState(resultingES.parent);
                    continue;
                }
                this.scan((Tree)statement);
            }
        }
        if (!DataFlowVisitor.lastStatementIsBreakOrReturn(tree)) {
            resultingES = this.executionState.merge(resultingES);
        }
        this.executionState = DataFlowVisitor.switchContainsDefaultLabel(tree) ? resultingES.parent.overrideBy(resultingES) : resultingES.parent.merge(resultingES);
    }

    private static boolean isBreakOrReturnStatement(StatementTree statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT});
    }

    private static boolean switchContainsDefaultLabel(SwitchStatementTree tree) {
        for (CaseGroupTree caseGroupTree : tree.cases()) {
            for (CaseLabelTree label : caseGroupTree.labels()) {
                if (!"default".equals(label.caseOrDefaultKeyword().text())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean lastStatementIsBreakOrReturn(SwitchStatementTree tree) {
        List cases = tree.cases();
        if (!cases.isEmpty()) {
            List lastStatements = ((CaseGroupTree)cases.get(cases.size() - 1)).body();
            return !lastStatements.isEmpty() && DataFlowVisitor.isBreakOrReturnStatement((StatementTree)lastStatements.get(lastStatements.size() - 1));
        }
        return false;
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan((Tree)tree.condition());
        this.visitLoopStatement(tree.statement());
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.visitLoopStatement(tree.statement());
        this.scan((Tree)tree.condition());
    }

    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.initializer());
        this.scan((Tree)tree.condition());
        this.scan(tree.update());
        this.visitLoopStatement(tree.statement());
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.scan((Tree)tree.variable());
        this.scan((Tree)tree.expression());
        this.visitLoopStatement(tree.statement());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.check.onExecutableElementInvocation(this.executionState, (Tree)tree, (List<ExpressionTree>)tree.arguments());
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        ExpressionTree expression = tree.expression();
        if (expression != null) {
            this.check.onValueReturned(this.executionState, tree, expression);
        }
    }

    private void visitLoopStatement(StatementTree tree) {
        this.executionState = new ExecutionState(this.executionState);
        this.scan((Tree)tree);
        this.scan((Tree)tree);
        this.executionState = this.executionState.restoreParent();
    }

    private void reportUnreachable(Set<State> states) {
        for (State state : states) {
            this.check.onValueUnreachable(this.executionState, state);
        }
    }
}

