/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractSerializableInnerClassRule
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            this.visitClassTree((ClassTree)tree);
        }
    }

    private void visitClassTree(ClassTree classTree) {
        Symbol.TypeSymbol symbol = classTree.symbol();
        if (AbstractSerializableInnerClassRule.isInnerClass(symbol) && AbstractSerializableInnerClassRule.directlyImplementsSerializable(symbol)) {
            Symbol.TypeSymbol methodOwner;
            Symbol owner = symbol.owner();
            if (owner.isTypeSymbol()) {
                Symbol.TypeSymbol ownerType = (Symbol.TypeSymbol)owner;
                if (this.isMatchingOuterClass(ownerType.type()) && !symbol.isStatic()) {
                    this.addIssue((Tree)classTree, "Make this inner class static");
                }
            } else if (owner.isMethodSymbol() && this.isMatchingOuterClass((methodOwner = (Symbol.TypeSymbol)owner.owner()).type()) && !owner.isStatic()) {
                String methodName = owner.name();
                this.addIssue((Tree)classTree, "Make \"" + methodName + "\" static");
            }
        }
    }

    private static boolean isInnerClass(Symbol.TypeSymbol typeSymbol) {
        return !typeSymbol.equals(((JavaSymbol.TypeJavaSymbol)typeSymbol).outermostClass());
    }

    protected boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private static boolean directlyImplementsSerializable(Symbol.TypeSymbol symbol) {
        for (Type type : symbol.interfaces()) {
            if (!type.is("java.io.Serializable")) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isMatchingOuterClass(Type var1);
}

