/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.NameCriteria;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2699", name="Tests should include assertions", priority=Priority.CRITICAL, tags={"junit"})
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="10min")
public class AssertionsInTestsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatcher MOCKITO_VERIFY = MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verify").withNoParameterConstraint();
    private static final MethodMatcher ASSERTJ_ASSERT_ALL = MethodMatcher.create().typeDefinition("org.assertj.core.api.SoftAssertions").name("assertAll");
    private static final MethodMatcher ASSERT_THAT = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("assertThat").addParameter(TypeCriteria.anyType());
    private static final MethodMatcher FEST_AS_METHOD = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("as").withNoParameterConstraint();
    private static final MethodMatcher FEST_DESCRIBED_AS_METHOD = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("describedAs").withNoParameterConstraint();
    private static final MethodMatcher FEST_OVERRIDE_ERROR_METHOD = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("overridingErrorMessage").withNoParameterConstraint();
    private static final MethodInvocationMatcherCollection ASSERTION_INVOCATION_MATCHERS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition("org.junit.Assert").name(NameCriteria.startsWith("assert")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.junit.Assert").name("fail").withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.junit.rules.ExpectedException").name(NameCriteria.startsWith("expect")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("junit.framework.Assert")).name(NameCriteria.startsWith("assert")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("junit.framework.Assert")).name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.fest.assertions.GenericAssert")).name(NameCriteria.any()).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.fest.assertions.Fail").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.fest.assertions.api.AbstractAssert")).name(NameCriteria.any()).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.fest.assertions.api.Fail").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.assertj.core.api.AbstractAssert")).name(NameCriteria.any()).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.assertj.core.api.Fail").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.assertj.core.api.Fail").name(NameCriteria.is("shouldHaveThrown")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.assertj.core.api.Assertions").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.assertj.core.api.Assertions").name(NameCriteria.is("shouldHaveThrown")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verifyNoMoreInteractions").withNoParameterConstraint());
    private final Deque<Boolean> methodContainsAssertion = new ArrayDeque<Boolean>();
    private final Deque<Boolean> methodContainsAssertjSoftAssertionUsage = new ArrayDeque<Boolean>();
    private final Deque<Boolean> methodContainsJunitSoftAssertionUsage = new ArrayDeque<Boolean>();
    private final Deque<Boolean> methodContainsAssertjAssertAll = new ArrayDeque<Boolean>();
    private final Deque<Boolean> inUnitTest = new ArrayDeque<Boolean>();
    private final Deque<ChainedMethods> chainedTo = new ArrayDeque<ChainedMethods>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree methodTree) {
        boolean isUnitTest = AssertionsInTestsCheck.isUnitTest(methodTree);
        this.inUnitTest.push(isUnitTest);
        this.methodContainsAssertion.push(false);
        this.methodContainsAssertjSoftAssertionUsage.push(false);
        this.methodContainsAssertjAssertAll.push(false);
        this.methodContainsJunitSoftAssertionUsage.push(false);
        super.visitMethod(methodTree);
        this.inUnitTest.pop();
        Boolean containsAssertion = this.methodContainsAssertion.pop();
        Boolean containsSoftAssertionDecl = this.methodContainsAssertjSoftAssertionUsage.pop();
        Boolean containsAssertjAssertAll = this.methodContainsAssertjAssertAll.pop();
        Boolean containsJunitSoftAssertionUsage = this.methodContainsJunitSoftAssertionUsage.pop();
        if (isUnitTest && !AssertionsInTestsCheck.expectAssertion(methodTree) && (!containsAssertion.booleanValue() || AssertionsInTestsCheck.badSoftAssertionUsage(containsSoftAssertionDecl, containsAssertjAssertAll, containsJunitSoftAssertionUsage))) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "Add at least one assertion to this test case.");
        }
    }

    private static boolean expectAssertion(MethodTree methodTree) {
        List annotationValues = methodTree.symbol().metadata().valuesForAnnotation("org.junit.Test");
        if (annotationValues != null) {
            for (SymbolMetadata.AnnotationValue annotationValue : annotationValues) {
                if (!"expected".equals(annotationValue.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean badSoftAssertionUsage(Boolean containsSoftAssertionDecl, Boolean containsAssertjAssertAll, Boolean containsJunitSoftAssertionUsage) {
        return containsSoftAssertionDecl != false && containsJunitSoftAssertionUsage == false && containsAssertjAssertAll == false;
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        if (!this.inUnitTest()) {
            return;
        }
        this.checkForAssertjSoftAssertions(mit);
        if (this.methodContainsAssertion.peek().booleanValue()) {
            return;
        }
        this.chainedTo.push(ChainedMethods.NONE);
        super.visitMethodInvocation(mit);
        ChainedMethods chainedToResult = this.chainedTo.pop();
        if (AssertionsInTestsCheck.containsAssertion(mit, chainedToResult)) {
            this.methodContainsAssertion.pop();
            this.methodContainsAssertion.push(Boolean.TRUE);
        }
        if (!this.chainedTo.isEmpty()) {
            if (ChainedMethods.ASSERT_THAT.equals((Object)chainedToResult) || ASSERT_THAT.matches(mit)) {
                this.chainedTo.pop();
                this.chainedTo.push(ChainedMethods.ASSERT_THAT);
            } else if (MOCKITO_VERIFY.matches(mit)) {
                this.chainedTo.pop();
                this.chainedTo.push(ChainedMethods.MOCKITO_VERIFY);
            }
        }
    }

    public void visitIdentifier(IdentifierTree tree) {
        Symbol symbol;
        Type type;
        if (this.inUnitTest() && (type = (symbol = tree.symbol()).type()) != null && type.isSubtypeOf("org.assertj.core.api.AbstractStandardSoftAssertions")) {
            AssertionsInTestsCheck.setTrue(this.methodContainsAssertjSoftAssertionUsage);
            if (symbol.metadata().isAnnotatedWith("org.junit.Rule")) {
                AssertionsInTestsCheck.setTrue(this.methodContainsJunitSoftAssertionUsage);
            }
        }
        super.visitIdentifier(tree);
    }

    private boolean inUnitTest() {
        return !this.inUnitTest.isEmpty() && this.inUnitTest.peek() != false;
    }

    private static void setTrue(Deque<Boolean> collection) {
        if (!collection.peek().booleanValue()) {
            collection.pop();
            collection.push(true);
        }
    }

    private void checkForAssertjSoftAssertions(MethodInvocationTree mit) {
        if (ASSERTJ_ASSERT_ALL.matches(mit)) {
            AssertionsInTestsCheck.setTrue(this.methodContainsAssertjAssertAll);
        }
    }

    private static boolean containsAssertion(MethodInvocationTree mit, ChainedMethods chainedToResult) {
        boolean isChainedToAssertThatWithBadResolution = ChainedMethods.ASSERT_THAT.equals((Object)chainedToResult) && mit.symbol().isUnknown();
        boolean isChainedToVerify = ChainedMethods.MOCKITO_VERIFY.equals((Object)chainedToResult);
        return isChainedToVerify || isChainedToAssertThatWithBadResolution || AssertionsInTestsCheck.isAssertion(mit);
    }

    private static boolean isAssertion(MethodInvocationTree mit) {
        return ASSERTION_INVOCATION_MATCHERS.anyMatch(mit) && !FEST_AS_METHOD.matches(mit) && !FEST_OVERRIDE_ERROR_METHOD.matches(mit) && !FEST_DESCRIBED_AS_METHOD.matches(mit);
    }

    private static boolean isUnitTest(MethodTree methodTree) {
        if (methodTree.symbol().metadata().isAnnotatedWith("org.junit.Test")) {
            return true;
        }
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        return enclosingClass != null && enclosingClass.type().isSubtypeOf("junit.framework.TestCase") && methodTree.simpleName().name().startsWith("test");
    }

    private static enum ChainedMethods {
        NONE,
        ASSERT_THAT,
        MOCKITO_VERIFY;

    }
}

