/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="MethodCyclomaticComplexity", name="Methods should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point above the threshold")
public class MethodComplexityCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 10;
    private static final MethodInvocationMatcherCollection EXCLUDED_METHODS = MethodInvocationMatcherCollection.create(MethodMatcher.create().name("equals").addParameter(TypeCriteria.anyType()), MethodMatcher.create().name("hashCode"));
    @RuleProperty(key="Threshold", description="The maximum authorized complexity.", defaultValue="10")
    private int max = 10;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (EXCLUDED_METHODS.anyMatch(methodTree)) {
            return;
        }
        List complexity = this.context.getComplexityNodes((Tree)methodTree);
        int size = complexity.size();
        if (size > this.max) {
            ArrayList<JavaFileScannerContext.Location> flow = new ArrayList<JavaFileScannerContext.Location>();
            for (Tree element : complexity) {
                flow.add(new JavaFileScannerContext.Location("+1", element));
            }
            this.reportIssue((Tree)methodTree.simpleName(), "The Cyclomatic Complexity of this method \"" + methodTree.simpleName().name() + "\" is " + size + " which is greater than " + this.max + " authorized.", flow, size - this.max);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

