/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00113", name="Files should contain an empty new line at the end", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class MissingNewLineAtEndOfFile_S00113_Check
extends SubscriptionBaseVisitor
implements CharsetAwareVisitor {
    private Charset charset;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.visitFile(context.getFile());
    }

    public void visitFile(File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            if (!this.endsWithNewline(randomAccessFile)) {
                this.addIssueOnFile("Add a new line at the end of this file.");
            }
        }
        catch (IOException e) {
            try {
                throw new SonarException((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(randomAccessFile);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)randomAccessFile);
    }

    private boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < 1L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 1L);
        byte[] chars = new byte[1];
        if (randomAccessFile.read(chars) < 1) {
            return false;
        }
        String ch = new String(chars, this.charset);
        return "\n".equals(ch) || "\r".equals(ch);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

