/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1199", name="Nested code blocks should not be used", priority=Priority.MAJOR, tags={"bad-practice"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class NestedBlocksCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCaseGroup(CaseGroupTree tree) {
        this.checkStatements(tree.body());
        super.visitCaseGroup(tree);
    }

    public void visitBlock(BlockTree tree) {
        this.checkStatements(tree.body());
        super.visitBlock(tree);
    }

    private void checkStatements(List<StatementTree> statements) {
        for (StatementTree statement : statements) {
            if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) continue;
            this.context.addIssue((Tree)statement, (JavaCheck)this, "Extract this nested code block into a method.");
        }
    }
}

