/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2063", name="Comparators should be \"Serializable\"", priority=Priority.MAJOR, tags={"pitfall", "serialization"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class SerializableComparatorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            ClassTree classTree = (ClassTree)tree;
            Symbol.TypeSymbol symbol = classTree.symbol();
            Type type = symbol.type();
            if (classTree.simpleName() != null && type.isSubtypeOf("java.util.Comparator") && !type.isSubtypeOf("java.io.Serializable") && !symbol.isAbstract()) {
                this.addIssue((Tree)classTree, "Make this class \"Serializable\".");
            }
        }
    }
}

