/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.SerializableContract;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="UnusedProtectedMethod", name="Unused protected methods should be removed", priority=Priority.MAJOR, tags={"unused"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class UnusedProtectedMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (UnusedProtectedMethodCheck.isUnusedNonOverridenProtectedMethod(asmMethod) && !this.asmClass.isAbstract() && !SerializableContract.methodMatch(asmMethod)) {
            int methodLineNumber = this.getMethodLineNumber(asmMethod);
            this.getContext().reportIssue((JavaCheck)this, this.getSourceFile(this.asmClass), "Protected method '" + asmMethod.getName() + "(...)' is never used.", methodLineNumber > 0 ? methodLineNumber : 0);
        }
    }

    private static boolean isUnusedNonOverridenProtectedMethod(AsmMethod asmMethod) {
        return !asmMethod.isUsed() && asmMethod.isProtected() && !asmMethod.isInherited();
    }
}

