/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import javax.annotation.Nullable;

public class JavaVersionHelper {
    private static final int JAVA_7 = 7;
    private static final int JAVA_8 = 8;

    private JavaVersionHelper() {
    }

    public static boolean java7Compatible(@Nullable Integer javaVersion) {
        return JavaVersionHelper.notSetOrAtLeast(javaVersion, 7);
    }

    public static boolean java8Compatible(@Nullable Integer javaVersion) {
        return JavaVersionHelper.notSetOrAtLeast(javaVersion, 8);
    }

    public static String java7CompatibilityMessage(@Nullable Integer javaVersion) {
        return JavaVersionHelper.compatibilityMessage(javaVersion, 7);
    }

    public static String java8CompatibilityMessage(@Nullable Integer javaVersion) {
        return JavaVersionHelper.compatibilityMessage(javaVersion, 8);
    }

    private static String compatibilityMessage(@Nullable Integer provided, int expeced) {
        return provided == null ? " (sonar.java.source not set. Assuming " + expeced + " or greater.)" : "";
    }

    private static boolean notSetOrAtLeast(@Nullable Integer providedJavaVersion, Integer requiredJavaVersion) {
        return providedJavaVersion == null || JavaVersionHelper.isAtLeast(providedJavaVersion, requiredJavaVersion);
    }

    private static boolean isAtLeast(Integer provided, Integer required) {
        return required <= provided;
    }
}

