/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.PatternUtils;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.NoSqale;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="ArchitecturalConstraint", name="Architectural constraints should be followed", priority=Priority.MAJOR)
@RuleTemplate
@NoSqale
public class ArchitectureCheck
extends SubscriptionBaseVisitor {
    @RuleProperty(description="Optional. If this property is not defined, all classes should adhere to this constraint. Ex : **.web.**")
    String fromClasses = "";
    @RuleProperty(description="Mandatory. Ex : java.util.Vector, java.util.Hashtable, java.util.Enumeration")
    String toClasses = "";
    private WildcardPattern[] fromPatterns;
    private WildcardPattern[] toPatterns;
    private Deque<String> shouldCheck = new LinkedList<String>();
    private Deque<Set<String>> issues = new LinkedList<Set<String>>();
    private Deque<Symbol> currentType = new LinkedList<Symbol>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.IDENTIFIER);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.check((IdentifierTree)tree);
        } else {
            this.initClass((ClassTree)tree);
        }
    }

    private void check(IdentifierTree tree) {
        Type type;
        String shouldCheckId = this.shouldCheck.peekFirst();
        if (shouldCheckId == null) {
            return;
        }
        Symbol symbol = tree.symbol();
        if (!symbol.isUnknown() && !this.currentType.contains(symbol.owner()) && (type = symbol.type()) != null) {
            String fullyQualifiedName = type.fullyQualifiedName();
            Set<String> currentIssues = this.issues.peekFirst();
            if (!currentIssues.contains(fullyQualifiedName) && WildcardPattern.match((WildcardPattern[])this.getToPatterns(), (String)fullyQualifiedName)) {
                this.addIssue((Tree)tree, shouldCheckId + " must not use " + fullyQualifiedName);
                currentIssues.add(fullyQualifiedName);
            }
        }
    }

    private void initClass(ClassTree tree) {
        String fullyQualifiedName = ((JavaSymbol.TypeJavaSymbol)tree.symbol()).getFullyQualifiedName();
        if (WildcardPattern.match((WildcardPattern[])this.getFromPatterns(), (String)fullyQualifiedName)) {
            this.shouldCheck.addFirst(fullyQualifiedName);
            this.issues.addFirst(new HashSet());
        } else {
            this.shouldCheck.addFirst(null);
            this.issues.addFirst(null);
        }
        this.currentType.push((Symbol)tree.symbol());
    }

    public void leaveNode(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.shouldCheck.removeFirst();
            this.issues.removeFirst();
            this.currentType.pop();
        }
    }

    private WildcardPattern[] getFromPatterns() {
        if (this.fromPatterns == null) {
            this.fromPatterns = PatternUtils.createPatterns(StringUtils.defaultIfEmpty((String)this.fromClasses, (String)"**"));
        }
        return this.fromPatterns;
    }

    private WildcardPattern[] getToPatterns() {
        if (this.toPatterns == null) {
            this.toPatterns = PatternUtils.createPatterns(this.toClasses);
        }
        return this.toPatterns;
    }
}

