/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1264", name="A \"while\" loop should be used instead of a \"for\" loop", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class ForLoopUsedAsWhileLoopCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FOR_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ForStatementTree methodTree = (ForStatementTree)tree;
        if (methodTree.initializer().isEmpty() && methodTree.update().isEmpty() && methodTree.condition() != null) {
            this.context.addIssue(tree, (JavaCheck)this, "Replace this \"for\" loop with a \"while\" loop.");
        }
    }
}

