/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2692", name="\"indexOf\" checks should not be for positive numbers", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class IndexOfWithPositiveNumberCheck
extends SubscriptionBaseVisitor {
    private static final String INDEXOF = "indexOf";
    private static final MethodInvocationMatcherCollection CHECKED_METHODS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition(String.class.getName()).name("indexOf").addParameter("int"), MethodMatcher.create().typeDefinition(String.class.getName()).name("indexOf").addParameter(String.class.getName()), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.util.List")).name("indexOf").addParameter("java.lang.Object"));

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.GREATER_THAN, (Object)Tree.Kind.LESS_THAN);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryTree = (BinaryExpressionTree)tree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN})) {
            this.checkForIssue(tree, binaryTree.leftOperand(), LiteralUtils.longLiteralValue((ExpressionTree)binaryTree.rightOperand()));
        } else {
            this.checkForIssue(tree, binaryTree.rightOperand(), LiteralUtils.longLiteralValue((ExpressionTree)binaryTree.leftOperand()));
        }
    }

    private void checkForIssue(Tree tree, ExpressionTree operand, @Nullable Long constant) {
        if (constant != null && constant == 0L && IndexOfWithPositiveNumberCheck.isIndexOfOnArrayOrString((Tree)operand)) {
            this.addIssue(tree, "0 is a valid index, but is ignored by this check.");
        }
    }

    private static boolean isIndexOfOnArrayOrString(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && CHECKED_METHODS.anyMatch((MethodInvocationTree)tree);
    }
}

