/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.locks.LockedVisitor;
import org.sonar.java.symexecengine.DataFlowVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2222", name="Locks should be released", priority=Priority.CRITICAL, tags={"bug", "cwe", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class LocksNotUnlockedCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        LockedVisitor visitor = new LockedVisitor();
        DataFlowVisitor.analyze((MethodTree)tree, visitor);
        for (Tree issueTree : visitor.getIssueTrees()) {
            this.addIssue(issueTree, "Unlock this lock.");
        }
    }
}

