/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.SyntaxNodePredicates;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.NameCriteria;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2386", name="Mutable fields should not be \"public static\"", priority=Priority.CRITICAL, tags={"cwe", "unpredictable", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="API_ABUSE")
@SqaleConstantRemediation(value="15min")
public class PublicStaticMutableMembersCheck
extends SubscriptionBaseVisitor {
    private static final Set<String> ALWAYS_MUTABLE_TYPES = ImmutableSet.of((Object)"java.awt.Point", (Object)"java.util.Date");
    private static final Set<String> MUTABLE_TYPES = ImmutableSet.builder().addAll(ALWAYS_MUTABLE_TYPES).add((Object)"java.util.Collection").add((Object)"java.util.Map").build();
    private static final String DECORATE = "decorate";
    private static final MethodInvocationMatcherCollection UNMODIFIABLE_METHOD_CALLS = MethodInvocationMatcherCollection.create().add(MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name(NameCriteria.startsWith("unmodifiable")).withNoParameterConstraint()).add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.apache.commons.collections.map.UnmodifiableMap")).name("decorate").withNoParameterConstraint()).add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.apache.commons.collections.set.UnmodifiableSet")).name("decorate").withNoParameterConstraint()).add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.apache.commons.collections.list.UnmodifiableList")).name("decorate").withNoParameterConstraint()).add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.apache.commons.collections4.map.UnmodifiableMap")).name("decorate").withNoParameterConstraint()).add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.apache.commons.collections4.set.UnmodifiableSet")).name("decorate").withNoParameterConstraint()).add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.apache.commons.collections4.list.UnmodifiableList")).name("decorate").withNoParameterConstraint());
    private static final MethodMatcher ARRAYS_AS_LIST = MethodMatcher.create().typeDefinition("java.util.Arrays").name("asList").withNoParameterConstraint();
    private static final Set<String> ACCEPTED_TYPES = ImmutableSet.of((Object)"com.google.common.collect.ImmutableMap", (Object)"com.google.common.collect.ImmutableCollection");
    private static final Set<String> ACCEPTED_NEW_TYPES = ImmutableSet.of((Object)"org.apache.commons.collections4.list.UnmodifiableList");
    private static final Set<Symbol> IMMUTABLE_CANDIDATES = new HashSet<Symbol>();
    private static final Multimap<Tree, Symbol> CLASS_IMMUTABLE_CANDIDATES = ArrayListMultimap.create();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.ASSIGNMENT);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        CLASS_IMMUTABLE_CANDIDATES.clear();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.checkAssignment((AssignmentExpressionTree)tree);
        } else {
            List members = ((ClassTree)tree).members();
            for (Tree member : members) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                this.preCheckVariable(tree, (VariableTree)member);
            }
        }
    }

    private void preCheckVariable(Tree owner, VariableTree variableTree) {
        Symbol symbol = variableTree.symbol();
        if (symbol != null && PublicStaticMutableMembersCheck.isPublicStatic(symbol) && PublicStaticMutableMembersCheck.isForbiddenType(symbol.type())) {
            if (PublicStaticMutableMembersCheck.isMutable(variableTree.initializer(), symbol.type())) {
                String message = "Make this member \"protected\".";
                if (owner.is(new Tree.Kind[]{Tree.Kind.INTERFACE})) {
                    message = MessageFormat.format("Move \"{0}\" to a class and lower its visibility", variableTree.simpleName().name());
                }
                this.addIssue((Tree)variableTree, message);
            } else {
                IMMUTABLE_CANDIDATES.add(symbol);
                CLASS_IMMUTABLE_CANDIDATES.put((Object)owner, (Object)symbol);
            }
        }
    }

    private void checkAssignment(AssignmentExpressionTree node) {
        Symbol symbol;
        ExpressionTree variable = ExpressionsHelper.skipParentheses(node.variable());
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            variable = ((MemberSelectExpressionTree)variable).identifier();
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && IMMUTABLE_CANDIDATES.contains(symbol = ((IdentifierTree)variable).symbol()) && PublicStaticMutableMembersCheck.isMutable(node.expression(), symbol.type())) {
            this.addIssue((Tree)variable, "Make member \"" + symbol.name() + "\" \"protected\".");
            IMMUTABLE_CANDIDATES.remove(symbol);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM})) {
            IMMUTABLE_CANDIDATES.removeAll(CLASS_IMMUTABLE_CANDIDATES.get((Object)tree));
        }
    }

    static boolean isMutable(@Nullable ExpressionTree initializer, Type type) {
        if (initializer == null) {
            return Iterables.any(ALWAYS_MUTABLE_TYPES, SyntaxNodePredicates.isSubtypeOf(type));
        }
        ExpressionTree expression = ExpressionsHelper.skipParentheses(initializer);
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            if (PublicStaticMutableMembersCheck.isAcceptedTypeOrUnmodifiableMethodCall(mit)) {
                return false;
            }
            if (ARRAYS_AS_LIST.matches(mit)) {
                return !mit.arguments().isEmpty();
            }
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            return !PublicStaticMutableMembersCheck.isAcceptedType(expression.symbolType(), ACCEPTED_NEW_TYPES);
        }
        return true;
    }

    private static boolean isAcceptedTypeOrUnmodifiableMethodCall(MethodInvocationTree mit) {
        Type type = mit.symbolType();
        return type.isUnknown() || PublicStaticMutableMembersCheck.isAcceptedType(type, ACCEPTED_TYPES) || UNMODIFIABLE_METHOD_CALLS.anyMatch(mit);
    }

    private static boolean isAcceptedType(Type type, Set<String> accepted) {
        for (String acceptedType : accepted) {
            if (!type.isSubtypeOf(acceptedType)) continue;
            return true;
        }
        return false;
    }

    static boolean isPublicStatic(Symbol symbol) {
        return symbol.isStatic() && symbol.isPublic();
    }

    static boolean isForbiddenType(Type type) {
        return type.isArray() || Iterables.any(MUTABLE_TYPES, SyntaxNodePredicates.isSubtypeOf(type));
    }
}

