/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInjectionChecker;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2077", name="Values passed to SQL commands should be sanitized", priority=Priority.CRITICAL, tags={"cwe", "owasp-a1", "sans-top25-insecure", "security", "sql", "hibernate"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INPUT_VALIDATION_AND_REPRESENTATION")
@SqaleConstantRemediation(value="20min")
public class SQLInjectionCheck
extends AbstractInjectionChecker {
    private static final MethodMatcher HIBERNATE_SESSION_CREATE_QUERY_MATCHER = MethodMatcher.create().callSite(TypeCriteria.subtypeOf("org.hibernate.Session")).name("createQuery").withNoParameterConstraint();
    private static final MethodMatcher STATEMENT_EXECUTE_QUERY_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.sql.Statement")).name("executeQuery").withNoParameterConstraint();
    private static final MethodInvocationMatcherCollection CONNECTION_MATCHERS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.sql.Connection")).name("prepareStatement").withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.sql.Connection")).name("prepareCall").withNoParameterConstraint());
    private static final MethodMatcher ENTITY_MANAGER_CREATE_NATIVE_QUERY_MATCHER = MethodMatcher.create().typeDefinition("javax.persistence.EntityManager").name("createNativeQuery").withNoParameterConstraint();

    public void visitNode(Tree tree) {
        MethodInvocationTree methodTree = (MethodInvocationTree)tree;
        boolean isHibernateCall = SQLInjectionCheck.isHibernateCall(methodTree);
        if (isHibernateCall || SQLInjectionCheck.isExecuteQueryOrPrepareStatement(methodTree) || SQLInjectionCheck.isEntityManagerCreateNativeQuery(methodTree)) {
            ExpressionTree arg = (ExpressionTree)methodTree.arguments().get(0);
            this.parameterName = "";
            if (this.isDynamicString((Tree)methodTree, arg, null, true)) {
                String message = "\"" + this.parameterName + "\" is provided externally to the method and not sanitized before use.";
                if (isHibernateCall) {
                    message = "Use Hibernate's parameter binding instead of concatenation.";
                }
                this.addIssue((Tree)methodTree, message);
            }
        }
    }

    private static boolean isExecuteQueryOrPrepareStatement(MethodInvocationTree methodTree) {
        return !methodTree.arguments().isEmpty() && (STATEMENT_EXECUTE_QUERY_MATCHER.matches(methodTree) || CONNECTION_MATCHERS.anyMatch(methodTree));
    }

    private static boolean isHibernateCall(MethodInvocationTree methodTree) {
        return HIBERNATE_SESSION_CREATE_QUERY_MATCHER.matches(methodTree);
    }

    private static boolean isEntityManagerCreateNativeQuery(MethodInvocationTree methodTree) {
        return ENTITY_MANAGER_CREATE_NATIVE_QUERY_MATCHER.matches(methodTree);
    }
}

