/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1948", name="Fields in a \"Serializable\" class should either be transient or serializable", priority=Priority.CRITICAL, tags={"bug", "cwe", "serialization"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class SerializableFieldInSerializableClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (SerializableFieldInSerializableClassCheck.isSerializable((Tree)classTree) && !SerializableFieldInSerializableClassCheck.hasSpecialHandlingSerializationMethods(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                this.checkVariableMember((VariableTree)member);
            }
        }
    }

    private void checkVariableMember(VariableTree variableTree) {
        if (!(SerializableFieldInSerializableClassCheck.isStatic(variableTree) || SerializableFieldInSerializableClassCheck.isTransientOrSerializable(variableTree) || SerializableFieldInSerializableClassCheck.isCollectionOfSerializable(variableTree.type()))) {
            IdentifierTree simpleName = variableTree.simpleName();
            this.reportIssue((Tree)simpleName, "Make \"" + simpleName.name() + "\" transient or serializable.");
        }
    }

    private static boolean isCollectionOfSerializable(TypeTree typeTree) {
        Type type = typeTree.symbolType();
        if (SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi(type) && typeTree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            TypeArguments typeArgs = ((ParameterizedTypeTree)typeTree).typeArguments();
            for (Tree t : typeArgs) {
                if (SerializableFieldInSerializableClassCheck.isSerializable(t)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isSubtypeOfCollectionApi(Type type) {
        return type.isSubtypeOf("java.util.Collection") || type.isSubtypeOf("java.util.Map");
    }

    private static boolean isStatic(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean hasSpecialHandlingSerializationMethods(ClassTree classTree) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        for (Tree member : classTree.members()) {
            MethodTree methodTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !ModifiersUtils.hasModifier((ModifiersTree)(methodTree = (MethodTree)member).modifiers(), (Modifier)Modifier.PRIVATE) || methodTree.parameters().size() != 1) continue;
            hasWriteObject |= "writeObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 1;
            hasReadObject |= "readObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 2;
        }
        return hasReadObject && hasWriteObject;
    }

    private static boolean isTransientOrSerializable(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.TRANSIENT) || SerializableFieldInSerializableClassCheck.isSerializable((Tree)member.type());
    }

    private static boolean isSerializable(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM, Tree.Kind.PRIMITIVE_TYPE})) {
            return true;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            Symbol.TypeSymbol symbol = ((ClassTree)tree).symbol();
            return SerializableFieldInSerializableClassCheck.implementsSerializable(symbol.type());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD, Tree.Kind.UNBOUNDED_WILDCARD})) {
            TypeTree bound = ((WildcardTree)tree).bound();
            return bound != null && SerializableFieldInSerializableClassCheck.implementsSerializable(bound.symbolType());
        }
        return SerializableFieldInSerializableClassCheck.implementsSerializable(((TypeTree)tree).symbolType());
    }

    private static boolean implementsSerializable(@Nullable Type type) {
        if (type == null || type.isUnknown() || type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return SerializableFieldInSerializableClassCheck.implementsSerializable(((Type.ArrayType)type).elementType());
        }
        if (type.isClass() || ((JavaType)type).isTagged(15)) {
            return type.erasure().isSubtypeOf("java.io.Serializable");
        }
        return false;
    }
}

