/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="SwitchLastCaseIsDefaultCheck", name="\"switch\" statements should end with a \"default\" clause", priority=Priority.MAJOR, tags={"cert", "cwe", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class SwitchLastCaseIsDefaultCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        CaseLabelTree defaultLabel = SwitchLastCaseIsDefaultCheck.getDefaultLabel(switchStatementTree);
        CaseLabelTree lastLabel = SwitchLastCaseIsDefaultCheck.getLastLabel(switchStatementTree);
        if (defaultLabel == null) {
            this.addIssue(tree, "Add a default case to this switch.");
        } else if (!defaultLabel.equals(lastLabel)) {
            this.addIssue((Tree)defaultLabel, "Move this default to the end of the switch.");
        }
    }

    private static CaseLabelTree getDefaultLabel(SwitchStatementTree switchStatementTree) {
        for (CaseGroupTree caseGroupTree : switchStatementTree.cases()) {
            for (CaseLabelTree caseLabelTree : caseGroupTree.labels()) {
                if (!JavaKeyword.DEFAULT.getValue().equals(caseLabelTree.caseOrDefaultKeyword().text())) continue;
                return caseLabelTree;
            }
        }
        return null;
    }

    private static CaseLabelTree getLastLabel(SwitchStatementTree switchStatementTree) {
        List labels;
        if (!switchStatementTree.cases().isEmpty() && !(labels = ((CaseGroupTree)switchStatementTree.cases().get(switchStatementTree.cases().size() - 1)).labels()).isEmpty()) {
            return (CaseLabelTree)labels.get(labels.size() - 1);
        }
        return null;
    }
}

