/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1860", name="Synchronization should not be based on Strings or boxed primitives", priority=Priority.BLOCKER, tags={"bug", "cert", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class SynchronizationOnStringOrBoxedCheck
extends SubscriptionBaseVisitor {
    private static final List<String> FORBIDDEN_TYPES = ImmutableList.of((Object)Boolean.class.getName(), (Object)Byte.class.getName(), (Object)Character.class.getName(), (Object)Double.class.getName(), (Object)Float.class.getName(), (Object)Integer.class.getName(), (Object)Long.class.getName(), (Object)Short.class.getName(), (Object)String.class.getName());

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SynchronizedStatementTree syncStatement = (SynchronizedStatementTree)tree;
        Type expressionType = syncStatement.expression().symbolType();
        if (expressionType.isPrimitive() || SynchronizationOnStringOrBoxedCheck.isForbiddenType(expressionType)) {
            this.addIssue((Tree)syncStatement, "Synchronize on a new \"Object\" instead.");
        }
    }

    private static boolean isForbiddenType(Type expressionType) {
        for (String forbiddenType : FORBIDDEN_TYPES) {
            if (!expressionType.is(forbiddenType)) continue;
            return true;
        }
        return false;
    }
}

