/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00105", name="Tabulation characters should not be used", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class TabCharacter_S00105_Check
extends SubscriptionBaseVisitor
implements CharsetAwareVisitor {
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.visitFile(context.getFile());
    }

    public void visitFile(File file) {
        List lines;
        try {
            lines = Files.readLines((File)file, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        for (String line : lines) {
            if (!line.contains("\t")) continue;
            this.addIssueOnFile("Replace all tab characters in this file by sequences of white-spaces.");
            break;
        }
    }
}

