/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2925", name="\"Thread.sleep\" should not be used in tests", priority=Priority.CRITICAL, tags={"bad-practice"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTS")
@SqaleConstantRemediation(value="20min")
public class ThreadSleepInTestsCheck
extends AbstractMethodDetection {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Remove this use of \"Thread.sleep()\".");
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.Thread").name("sleep").withNoParameterConstraint());
    }
}

