/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1848", name="Objects should not be created to be dropped immediately without being used", priority=Priority.CRITICAL, tags={"bug", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class UselessObjectCreationCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionStatementTree expressionStatement = (ExpressionStatementTree)tree;
        ExpressionTree expression = expressionStatement.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTreeImpl newClassTree = (NewClassTreeImpl)expression;
            String className = newClassTree.getConstructorIdentifier().name();
            this.addIssue(tree, "Either remove this useless object instantiation of class \"" + className + "\" or use it");
        }
    }
}

