/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.symexecengine;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.java.symexecengine.State;
import org.sonar.java.symexecengine.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Tree;

public class ExecutionState {
    final ExecutionState parent;
    private SetMultimap<Symbol, SymbolicValue> reachableValues = HashMultimap.create();
    private SetMultimap<Symbol, SymbolicValue> unreachableValues = HashMultimap.create();
    private List<Symbol> definedInState = Lists.newArrayList();
    private Map<SymbolicValue, State> stateOfValue = Maps.newHashMap();

    public ExecutionState(ExecutionState executionState) {
        this.parent = executionState;
        this.reachableValues = HashMultimap.create(executionState.reachableValues);
        this.unreachableValues = HashMultimap.create(executionState.unreachableValues);
    }

    public ExecutionState() {
        this.parent = null;
    }

    public void defineSymbol(Symbol symbol) {
        this.definedInState.add(symbol);
    }

    public ExecutionState merge(ExecutionState executionState) {
        for (Symbol symbol : executionState.reachableValues.keys()) {
            if (executionState.definedInState.contains(symbol)) continue;
            this.reachableValues.putAll((Object)symbol, (Iterable)executionState.reachableValues.get((Object)symbol));
        }
        for (Symbol symbol : executionState.unreachableValues.keys()) {
            if (executionState.definedInState.contains(symbol)) continue;
            this.unreachableValues.putAll((Object)symbol, (Iterable)executionState.unreachableValues.get((Object)symbol));
        }
        for (Symbol symbol : this.unreachableValues.keys()) {
            for (SymbolicValue value : this.unreachableValues.get((Object)symbol)) {
                this.reachableValues.remove((Object)symbol, (Object)value);
            }
        }
        for (Map.Entry<SymbolicValue, State> valueStateEntry : executionState.stateOfValue.entrySet()) {
            SymbolicValue value = valueStateEntry.getKey();
            State state = valueStateEntry.getValue();
            State valueState = this.getStateOfValue(value);
            valueState = valueState == null ? state : valueState.merge(state);
            this.stateOfValue.put(value, valueState);
        }
        return this;
    }

    public ExecutionState overrideBy(ExecutionState executionState) {
        this.unreachableValues.putAll(executionState.unreachableValues);
        this.reachableValues = executionState.reachableValues;
        this.stateOfValue.putAll(executionState.stateOfValue);
        return this;
    }

    public ExecutionState restoreParent() {
        return this.parent.merge(this);
    }

    Set<State> getStatesOfCurrentExecutionState() {
        HashSet results = Sets.newHashSet();
        for (Symbol symbol : this.definedInState) {
            for (SymbolicValue value : Iterables.concat((Iterable)this.reachableValues.get((Object)symbol), (Iterable)this.unreachableValues.get((Object)symbol))) {
                State state = this.stateOfValue.get(value);
                if (state == null) continue;
                results.add(state);
            }
        }
        return results;
    }

    public List<State> getStatesOf(Symbol symbol) {
        ArrayList states = Lists.newArrayList();
        for (SymbolicValue value : Iterables.concat((Iterable)this.reachableValues.get((Object)symbol), (Iterable)this.unreachableValues.get((Object)symbol))) {
            State state = this.stateOfValue.get(value);
            if (state == null) continue;
            states.add(state);
        }
        return states;
    }

    @CheckForNull
    private State getStateOfValue(SymbolicValue value) {
        ExecutionState currentState = this;
        while (currentState != null) {
            State state = currentState.stateOfValue.get(value);
            if (state != null) {
                return state;
            }
            currentState = currentState.parent;
        }
        return null;
    }

    Iterable<SymbolicValue> getValues(Symbol symbol) {
        return this.reachableValues.get((Object)symbol);
    }

    public SymbolicValue createValueForSymbol(Symbol symbol, Tree tree) {
        Set values = this.reachableValues.get((Object)symbol);
        this.unreachableValues.putAll((Object)symbol, (Iterable)values);
        values.clear();
        SymbolicValue value = new SymbolicValue(tree);
        this.reachableValues.put((Object)symbol, (Object)value);
        this.stateOfValue.put(value, State.UNSET);
        return value;
    }

    public void markValueAs(Symbol symbol, State state) {
        for (SymbolicValue value : this.getValues(symbol)) {
            this.stateOfValue.put(value, state);
        }
    }

    public void markValueAs(SymbolicValue value, State state) {
        this.stateOfValue.put(value, state);
    }
}

