/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1610", name="Abstract classes without fields should be converted to interfaces", priority=Priority.MAJOR, tags={"java8"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class AbstractClassNoFieldShouldBeInterfaceCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.superClass() == null && AbstractClassNoFieldShouldBeInterfaceCheck.classIsAbstract(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoFieldAndProtectedMethod(classTree)) {
            this.addIssue((Tree)classTree, "Convert the abstract class \"" + classTree.simpleName().name() + "\" into an interface." + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean classIsAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT);
    }

    private static boolean classHasNoFieldAndProtectedMethod(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)member).modifiers(), (Modifier)Modifier.PROTECTED))) continue;
            return false;
        }
        return true;
    }
}

