/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class AbstractDeprecatedChecker
extends SubscriptionBaseVisitor {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private static final Tree.Kind[] API_KINDS = PublicApiChecker.apiKinds();

    public List<Tree.Kind> nodesToVisit() {
        return Lists.newArrayList((Object[])API_KINDS);
    }

    public static boolean hasJavadocDeprecatedTag(Tree tree) {
        return AbstractDeprecatedChecker.hasJavadocDeprecatedTag(PublicApiChecker.getApiJavadoc((Tree)tree));
    }

    public static boolean hasJavadocDeprecatedTag(@Nullable String comment) {
        return comment != null && comment.startsWith("/**") && comment.contains("@deprecated");
    }

    public static boolean hasDeprecatedAnnotation(Tree tree) {
        if (tree.is(CLASS_KINDS)) {
            return AbstractDeprecatedChecker.hasDeprecatedAnnotation((ClassTree)tree);
        }
        if (tree.is(METHOD_KINDS)) {
            return AbstractDeprecatedChecker.hasDeprecatedAnnotation((MethodTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return AbstractDeprecatedChecker.hasDeprecatedAnnotation((VariableTree)tree);
        }
        return false;
    }

    private static boolean hasDeprecatedAnnotation(ClassTree classTree) {
        return AbstractDeprecatedChecker.hasDeprecatedAnnotation(classTree.modifiers().annotations());
    }

    private static boolean hasDeprecatedAnnotation(VariableTree variableTree) {
        return AbstractDeprecatedChecker.hasDeprecatedAnnotation(variableTree.modifiers().annotations());
    }

    private static boolean hasDeprecatedAnnotation(MethodTree methodTree) {
        return AbstractDeprecatedChecker.hasDeprecatedAnnotation(methodTree.modifiers().annotations());
    }

    private static boolean hasDeprecatedAnnotation(Iterable<AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            if (!AbstractDeprecatedChecker.isDeprecated(annotationTree)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeprecated(AnnotationTree tree) {
        return tree.annotationType().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "Deprecated".equals(((IdentifierTree)tree.annotationType()).name());
    }
}

