/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2186", name="JUnit assertions should not be used in \"run\" methods", priority=Priority.CRITICAL, tags={"bug", "junit"})
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="30min")
@ActivatedByDefault
public class AssertionInThreadRunCheck
extends SubscriptionBaseVisitor {
    private static final Iterable<String> CHECKED_TYPES = Lists.newArrayList((Object[])new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase", "org.fest.assertions.Assertions"});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        BlockTree block = methodTree.block();
        if (block != null && AssertionInThreadRunCheck.isRunMethod(methodTree)) {
            block.accept((TreeVisitor)new AssertionsVisitor());
        }
    }

    private static boolean isRunMethod(MethodTree methodTree) {
        return methodTree.symbol().owner().type().isSubtypeOf("java.lang.Runnable") && "run".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty();
    }

    private class AssertionsVisitor
    extends BaseTreeVisitor {
        private AssertionsVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Type type = tree.symbol().owner().type();
            if (this.isCheckedType(type)) {
                AssertionInThreadRunCheck.this.addIssue((Tree)tree, "Remove this assertion.");
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isCheckedType(Type type) {
            for (String checkedType : CHECKED_TYPES) {
                if (!type.is(checkedType)) continue;
                return true;
            }
            return false;
        }
    }
}

