/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2278", name="Neither DES (Data Encryption Standard) nor DESede (3DES) should be used", priority=Priority.CRITICAL, tags={"cwe", "owasp-a6", "sans-top25-porous", "security"})
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="20min")
public class AvoidDESCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("javax.crypto.Cipher").name("getInstance").withNoParameterConstraint());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArg = (ExpressionTree)mit.arguments().get(0);
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArg);
        if (defaultPropertyValue == null) {
            defaultPropertyValue = firstArg;
        }
        if (defaultPropertyValue != null && defaultPropertyValue.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.checkIssue(firstArg, (LiteralTree)defaultPropertyValue);
        }
    }

    private void checkIssue(ExpressionTree argumentForReport, LiteralTree argument) {
        String[] transformationElements = LiteralUtils.trimQuotes((String)argument.value()).split("/");
        if (transformationElements.length > 0 && AvoidDESCheck.isExcludedAlgorithm(transformationElements[0])) {
            this.reportIssue((Tree)argumentForReport, "Use the recommended AES (Advanced Encryption Standard) instead.");
        }
    }

    private static boolean isExcludedAlgorithm(String algorithm) {
        return "DES".equals(algorithm) || "DESede".equals(algorithm);
    }
}

