/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1125", name="Literal boolean values should not be used in condition expressions", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BooleanLiteralCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.CONDITIONAL_AND, (Object)Tree.Kind.CONDITIONAL_OR, (Object)Tree.Kind.LOGICAL_COMPLEMENT);
    }

    public void visitNode(Tree tree) {
        LiteralTree literal = tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT}) ? BooleanLiteralCheck.getBooleanLiteral((Tree)((UnaryExpressionTree)tree).expression()) : BooleanLiteralCheck.getBooleanLiteralOperands((BinaryExpressionTree)tree);
        if (literal != null) {
            this.reportIssue((Tree)literal, "Remove the literal \"" + literal.value() + "\" boolean value.");
        }
    }

    private static LiteralTree getBooleanLiteral(Tree tree) {
        LiteralTree result = null;
        if (tree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            result = (LiteralTree)tree;
        }
        return result;
    }

    private static LiteralTree getBooleanLiteralOperands(BinaryExpressionTree tree) {
        LiteralTree result = BooleanLiteralCheck.getBooleanLiteral((Tree)tree.leftOperand());
        if (result == null) {
            result = BooleanLiteralCheck.getBooleanLiteral((Tree)tree.rightOperand());
        }
        return result;
    }
}

