/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2061", name="Custom serialization method signatures should meet requirements", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class CustomSerializationMethodCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (this.hasSemantic() && CustomSerializationMethodCheck.isOwnedBySerializable(methodSymbol)) {
            if (CustomSerializationMethodCheck.hasSignature(methodSymbol, "writeObject", "java.io.ObjectOutputStream") || CustomSerializationMethodCheck.hasSignature(methodSymbol, "readObject", "java.io.ObjectInputStream") || CustomSerializationMethodCheck.hasSignature(methodSymbol, "readObjectNoData")) {
                this.checkPrivate(methodTree);
                this.checkNotStatic(methodTree);
            } else if (CustomSerializationMethodCheck.hasSignature(methodSymbol, "writeReplace") || CustomSerializationMethodCheck.hasSignature(methodSymbol, "readResolve")) {
                this.checkNotStatic(methodTree);
                this.checkReturnType(methodTree, "java.lang.Object");
            }
        }
    }

    private static boolean isOwnedBySerializable(Symbol.MethodSymbol methodSymbol) {
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)methodSymbol.owner();
        return owner.type().isSubtypeOf("java.io.Serializable");
    }

    private static boolean hasSignature(Symbol.MethodSymbol methodSymbol, String name, String paramType) {
        return name.equals(methodSymbol.name()) && CustomSerializationMethodCheck.hasSingleParam(methodSymbol, paramType);
    }

    private static boolean hasSignature(Symbol.MethodSymbol methodSymbol, String name) {
        return name.equals(methodSymbol.name()) && methodSymbol.parameterTypes().isEmpty();
    }

    private static boolean hasSingleParam(Symbol.MethodSymbol methodSymbol, String searchedParamType) {
        List parametersTypes = methodSymbol.parameterTypes();
        return parametersTypes.size() == 1 && ((Type)parametersTypes.get(0)).is(searchedParamType);
    }

    private void checkNotStatic(MethodTree methodTree) {
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (methodSymbol.isStatic()) {
            this.reportIssue((Tree)methodTree.simpleName(), "The \"static\" modifier should not be applied to \"" + methodSymbol.name() + "\".");
        }
    }

    private void checkPrivate(MethodTree methodTree) {
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (!methodSymbol.isPrivate()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Make \"" + methodSymbol.name() + "\" \"private\".");
        }
    }

    private void checkReturnType(MethodTree methodTree, String requiredReturnType) {
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (!methodSymbol.returnType().type().is(requiredReturnType)) {
            this.reportIssue((Tree)methodTree.simpleName(), "\"" + methodSymbol.name() + "\" should return \"" + requiredReturnType + "\".");
        }
    }
}

