/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2160", name="Subclasses that add fields should override \"equals\"", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class EqualsNotOverriddenInSubclassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.hasSemantic() && EqualsNotOverriddenInSubclassCheck.hasAtLeastOneField(classTree) && !EqualsNotOverriddenInSubclassCheck.implementsEquals(classTree) && EqualsNotOverriddenInSubclassCheck.parentClassImplementsEquals(classTree)) {
            this.addIssue((Tree)classTree, "Override this superclass' \"equals\" method.");
        }
    }

    private static boolean hasAtLeastOneField(ClassTree classTree) {
        for (Tree member : classTree.members()) {
            if (!EqualsNotOverriddenInSubclassCheck.isField(member)) continue;
            return true;
        }
        return false;
    }

    private static boolean isField(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && !ModifiersUtils.hasModifier((ModifiersTree)((VariableTree)tree).modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean implementsEquals(ClassTree classTree) {
        return EqualsNotOverriddenInSubclassCheck.hasNotFinalEqualsMethod(classTree.symbol());
    }

    private static boolean parentClassImplementsEquals(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        if (superClass != null) {
            Type superClassType = superClass.symbolType();
            while (superClassType.symbol().isTypeSymbol() && !superClassType.is("java.lang.Object")) {
                Symbol.TypeSymbol superClassSymbol = superClassType.symbol();
                if (EqualsNotOverriddenInSubclassCheck.hasNotFinalEqualsMethod(superClassSymbol)) {
                    return true;
                }
                superClassType = superClassSymbol.superClass();
            }
        }
        return false;
    }

    private static boolean hasNotFinalEqualsMethod(Symbol.TypeSymbol superClassSymbol) {
        for (Symbol symbol : superClassSymbol.lookupSymbols("equals")) {
            if (!EqualsNotOverriddenInSubclassCheck.isEqualsMethod(symbol) || symbol.isFinal()) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualsMethod(Symbol symbol) {
        if (symbol.isMethodSymbol()) {
            List parameterTypes = ((Symbol.MethodSymbol)symbol).parameterTypes();
            return !parameterTypes.isEmpty() && ((Type)parameterTypes.get(0)).is("java.lang.Object");
        }
        return false;
    }
}

