/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1194", name="\"java.lang.Error\" should not be extended", priority=Priority.CRITICAL, tags={"error-handling", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="10min")
public class ErrorClassExtendedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && superClass != null) {
            MemberSelectExpressionTree mse;
            if (superClass.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree idt = (IdentifierTree)superClass;
                if ("Error".equals(idt.name())) {
                    this.context.reportIssue((JavaCheck)this, (Tree)superClass, "Extend \"java.lang.Exception\" or one of its subclasses.");
                }
            } else if (superClass.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "Error".equals((mse = (MemberSelectExpressionTree)superClass).identifier().name()) && ErrorClassExtendedCheck.isJavaLang(mse.expression())) {
                this.context.reportIssue((JavaCheck)this, (Tree)superClass, "Extend \"java.lang.Exception\" or one of its subclasses.");
            }
        }
        super.visitClass(tree);
    }

    private static boolean isJavaLang(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
            if (!"lang".equals(mse.identifier().name())) {
                return false;
            }
            if (mse.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree idt = (IdentifierTree)mse.expression();
                return "java".equals(idt.name());
            }
        }
        return false;
    }
}

