/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2039", name="Member variable visibility should be specified", priority=Priority.CRITICAL, tags={"security"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class FieldModifierCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !FieldModifierCheck.hasNoVisibilityModifier((VariableTree)member)) continue;
            IdentifierTree simpleName = ((VariableTree)member).simpleName();
            this.reportIssue((Tree)simpleName, "Explicitly declare the visibility for \"" + simpleName.name() + "\".");
        }
    }

    private static boolean hasNoVisibilityModifier(VariableTree member) {
        ModifiersTree modifiers = member.modifiers();
        return !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PUBLIC) && !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PRIVATE) && !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PROTECTED);
    }
}

