/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1213", name="The members of an interface declaration or class should appear in a pre-defined order", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class IncorrectOrderOfMembersCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String[] NAMES = new String[]{"variable", "constructor", "method"};
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        int prev = 0;
        for (int i = 0; i < tree.members().size(); ++i) {
            int priority;
            Tree member = (Tree)tree.members().get(i);
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                priority = 0;
            } else if (member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                priority = 1;
            } else {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                priority = 2;
            }
            if (priority < prev) {
                this.context.addIssue(member, (JavaCheck)this, "Move this " + NAMES[priority] + " to comply with Java Code Conventions.");
                continue;
            }
            prev = priority;
        }
        super.visitClass(tree);
    }
}

