/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00121", name="Control structures should use curly braces", priority=Priority.MAJOR, tags={"cert", "misra", "pitfall"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class MissingCurlyBraces_S00121_Check
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.FOR_EACH_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.DO_STATEMENT);
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case WHILE_STATEMENT: {
                this.checkStatement(((WhileStatementTree)tree).statement(), tree);
                break;
            }
            case DO_STATEMENT: {
                this.checkStatement(((DoWhileStatementTree)tree).statement(), tree);
                break;
            }
            case FOR_STATEMENT: {
                this.checkStatement(((ForStatementTree)tree).statement(), tree);
                break;
            }
            case FOR_EACH_STATEMENT: {
                this.checkStatement(((ForEachStatement)tree).statement(), tree);
                break;
            }
            case IF_STATEMENT: {
                IfStatementTree ifStmt = (IfStatementTree)tree;
                this.checkIfStatement(ifStmt);
                break;
            }
        }
    }

    private void checkIfStatement(IfStatementTree ifStmt) {
        this.checkStatement(ifStmt.thenStatement(), (Tree)ifStmt);
        StatementTree elseStmt = ifStmt.elseStatement();
        if (elseStmt != null && !elseStmt.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkStatement(elseStmt, (Tree)ifStmt.elseKeyword());
        }
    }

    private void checkStatement(StatementTree statement, Tree tree) {
        if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.addIssue(tree, "Missing curly brace.");
        }
    }
}

