/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.CommentContainsPatternChecker;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1310", name="\"NOPMD\" suppression comments should not be used", priority=Priority.MINOR, tags={"bad-practice"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class NoPmdTagPresenceCheck
extends SubscriptionBaseVisitor {
    private static final String PATTERN = "NOPMD";
    private static final String MESSAGE = "Remove usage of this \"NOPMD\" suppression comment filter.";
    private final CommentContainsPatternChecker checker = new CommentContainsPatternChecker(this, "NOPMD", "Remove usage of this \"NOPMD\" suppression comment filter.");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        this.checker.checkTrivia(syntaxTrivia);
    }
}

