/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2118", name="Non-serializable classes should not be written", priority=Priority.CRITICAL, tags={"bug", "serialization"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class NonSerializableWriteCheck
extends SubscriptionBaseVisitor {
    private static final MethodMatcher WRITE_OBJECT_MATCHER = MethodMatcher.create().typeDefinition("java.io.ObjectOutputStream").name("writeObject").addParameter("java.lang.Object");
    private final List<Symbol> testedSymbols = Lists.newArrayList();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.INSTANCE_OF);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.testedSymbols.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.visitMethodInvocation((MethodInvocationTree)tree);
            } else {
                this.visitInstanceOf((InstanceOfTree)tree);
            }
        }
    }

    private void visitInstanceOf(InstanceOfTree instanceOfTree) {
        ExpressionTree expression = instanceOfTree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && instanceOfTree.type().symbolType().is("java.io.Serializable")) {
            this.testedSymbols.add(((IdentifierTree)expression).symbol());
        }
    }

    private boolean isTestedSymbol(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)tree).symbol();
            return this.testedSymbols.contains(symbol);
        }
        return false;
    }

    private void visitMethodInvocation(MethodInvocationTree methodInvocation) {
        ExpressionTree argument;
        if (WRITE_OBJECT_MATCHER.matches(methodInvocation) && !NonSerializableWriteCheck.isAcceptableType((argument = (ExpressionTree)methodInvocation.arguments().get(0)).symbolType()) && !this.isTestedSymbol(argument)) {
            this.addIssue((Tree)methodInvocation, "Make the \"" + argument.symbolType().fullyQualifiedName() + "\" class \"Serializable\" or don't write it.");
        }
    }

    private static boolean isAcceptableType(Type argType) {
        return argType.isSubtypeOf("java.io.Serializable") || argType.is("java.lang.Object") || argType.isPrimitive() || !argType.isClass();
    }
}

