/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="RedundantThrowsDeclarationCheck", name="Throws declarations should not be superfluous", priority=Priority.MINOR, tags={"clumsy", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class RedundantThrowsDeclarationCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        ListTree thrownList = ((MethodTree)tree).throwsClauses();
        HashSet<String> reported = new HashSet<String>();
        for (TypeTree typeTree : thrownList) {
            Type symbolType = typeTree.symbolType();
            String fullyQualifiedName = symbolType.fullyQualifiedName();
            if (reported.contains(fullyQualifiedName)) continue;
            String superTypeName = RedundantThrowsDeclarationCheck.isSubclassOfAny(symbolType, (ListTree<TypeTree>)thrownList);
            if (superTypeName != null) {
                this.addIssue((Tree)typeTree, "Remove the declaration of thrown exception '" + fullyQualifiedName + "' which is a subclass of '" + superTypeName + "'.");
            } else if (symbolType.isSubtypeOf("java.lang.RuntimeException")) {
                this.addIssue((Tree)typeTree, "Remove the declaration of thrown exception '" + fullyQualifiedName + "' which is a runtime exception.");
            } else if (RedundantThrowsDeclarationCheck.declaredMoreThanOnce(fullyQualifiedName, (ListTree<TypeTree>)thrownList)) {
                this.addIssue((Tree)typeTree, "Remove the redundant '" + fullyQualifiedName + "' thrown exception declaration(s).");
            }
            reported.add(fullyQualifiedName);
        }
    }

    private static boolean declaredMoreThanOnce(String fullyQualifiedName, ListTree<TypeTree> thrown) {
        boolean firstOccurrenceFound = false;
        for (TypeTree typeTree : thrown) {
            if (!typeTree.symbolType().is(fullyQualifiedName)) continue;
            if (firstOccurrenceFound) {
                return true;
            }
            firstOccurrenceFound = true;
        }
        return false;
    }

    private static String isSubclassOfAny(Type type, ListTree<TypeTree> thrownList) {
        for (TypeTree thrown : thrownList) {
            String name = thrown.symbolType().fullyQualifiedName();
            if (type.is(name) || !type.isSubtypeOf(name)) continue;
            return name;
        }
        return null;
    }
}

