/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2183", name="Ints and longs should not be shifted by more than their number of bits-1", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ShiftOnIntOrLongCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.LEFT_SHIFT, (Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT, (Object)Tree.Kind.RIGHT_SHIFT, (Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionTree shift;
        String identifier;
        if (tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT})) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
            if (ShiftOnIntOrLongCheck.isZeroMaskShift(binaryExpressionTree)) {
                return;
            }
            identifier = ShiftOnIntOrLongCheck.getIdentifierName(binaryExpressionTree.leftOperand());
            shift = binaryExpressionTree.rightOperand();
        } else {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)tree;
            identifier = ShiftOnIntOrLongCheck.getIdentifierName(assignmentExpressionTree.variable());
            shift = assignmentExpressionTree.expression();
        }
        this.checkShift((ExpressionTree)tree, shift, identifier);
    }

    private void checkShift(ExpressionTree tree, ExpressionTree shift, @Nullable String identifier) {
        Long literalValue = LiteralUtils.longLiteralValue((ExpressionTree)shift);
        if (literalValue != null) {
            int numericalBase = ShiftOnIntOrLongCheck.getNumericalBase(tree);
            long numberBits = literalValue;
            long reducedNumberBits = numberBits % (long)numericalBase;
            if (ShiftOnIntOrLongCheck.isInvalidShift(reducedNumberBits, numberBits, numericalBase)) {
                this.addIssue((Tree)tree, ShiftOnIntOrLongCheck.getMessage(reducedNumberBits, reducedNumberBits, numericalBase, identifier));
            }
        }
    }

    private static boolean isInvalidShift(long reducedNumberBits, long numberBits, int base) {
        return reducedNumberBits == 0L || ShiftOnIntOrLongCheck.tooManyBits(numberBits, base);
    }

    private static boolean isZeroMaskShift(BinaryExpressionTree binaryExpressionTree) {
        return ShiftOnIntOrLongCheck.isLiteralValue(binaryExpressionTree.leftOperand(), 1L) && ShiftOnIntOrLongCheck.isLiteralValue(binaryExpressionTree.rightOperand(), 0L);
    }

    private static boolean isLiteralValue(ExpressionTree tree, long value) {
        Long evaluatedValue = LiteralUtils.longLiteralValue((ExpressionTree)tree);
        return evaluatedValue != null && evaluatedValue == value;
    }

    private static String getMessage(long numberBits, long reducedNumberBits, int base, @Nullable String identifier) {
        if (reducedNumberBits == 0L) {
            return "Remove this useless shift";
        }
        if (base == 32) {
            return MessageFormat.format(identifier == null ? "Either use a \"long\" or correct this shift to {0}" : "Either make \"{1}\" a \"long\" or correct this shift to {0}", reducedNumberBits, identifier);
        }
        return MessageFormat.format("Correct this shift to {0}", reducedNumberBits);
    }

    private static int getNumericalBase(ExpressionTree tree) {
        if (tree.symbolType().is("int")) {
            return 32;
        }
        return 64;
    }

    private static boolean tooManyBits(long numberBits, int base) {
        return Math.abs(numberBits) >= (long)base;
    }

    @CheckForNull
    private static String getIdentifierName(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
            return ShiftOnIntOrLongCheck.getIdentifierName(((ArrayAccessExpressionTree)tree).expression());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).name();
        }
        return null;
    }
}

