/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2325", name="\"private\" methods that don't access instance data should be \"static\"", priority=Priority.MINOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class StaticMethodCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_IO_SERIALIZABLE = "java.io.Serializable";
    private static final MethodInvocationMatcherCollection EXCLUDED_SERIALIZABLE_METHODS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.io.Serializable")).name("readObject").addParameter(TypeCriteria.subtypeOf("java.io.ObjectInputStream")), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.io.Serializable")).name("writeObject").addParameter(TypeCriteria.subtypeOf("java.io.ObjectOutputStream")), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.io.Serializable")).name("readObjectNoData"));
    private JavaFileScannerContext context;
    private Deque<Symbol> outerClasses = new LinkedList<Symbol>();
    private Deque<Boolean> atLeastOneReference = new LinkedList<Boolean>();
    private Deque<Symbol> currentMethod = new LinkedList<Symbol>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        this.outerClasses.push((Symbol)tree.symbol());
        super.visitClass(tree);
        this.outerClasses.pop();
    }

    public void visitMethod(MethodTree tree) {
        if (StaticMethodCheck.isExcluded(tree)) {
            return;
        }
        Symbol.MethodSymbol symbol = tree.symbol();
        if (this.outerClasses.size() > 1 && !this.outerClasses.peek().isStatic()) {
            return;
        }
        this.atLeastOneReference.push(Boolean.FALSE);
        this.currentMethod.push((Symbol)symbol);
        this.scan((Tree)tree.block());
        Boolean oneReference = this.atLeastOneReference.pop();
        this.currentMethod.pop();
        if (symbol.isPrivate() && !symbol.isStatic() && !oneReference.booleanValue()) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), "Make \"" + symbol.name() + "\" a \"static\" method.");
        }
    }

    private static boolean isExcluded(MethodTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) || EXCLUDED_SERIALIZABLE_METHODS.anyMatch(tree);
    }

    public void visitIdentifier(IdentifierTree tree) {
        super.visitIdentifier(tree);
        Symbol symbol = tree.symbol();
        if (!this.atLeastOneReference.isEmpty() && !this.atLeastOneReference.peek().booleanValue() && !this.currentMethod.peek().equals(symbol) && this.referenceInstance(symbol)) {
            this.atLeastOneReference.pop();
            this.atLeastOneReference.push(Boolean.TRUE);
        }
    }

    private boolean referenceInstance(Symbol symbol) {
        return symbol.isUnknown() || !symbol.isStatic() && this.fromInstance(symbol.owner());
    }

    private boolean fromInstance(Symbol owner) {
        for (Symbol outerClass : this.outerClasses) {
            Type ownerType = owner.type();
            if (ownerType == null) continue;
            if (owner.equals(outerClass) || outerClass.type().isSubtypeOf(ownerType)) {
                return true;
            }
            return this.fromInstance(ownerType.symbol().owner());
        }
        return false;
    }
}

