/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2693", name="Threads should not be started in constructors", priority=Priority.MAJOR, tags={"multi-threading", "pitfall"})
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class ThreadStartedInConstructorCheck
extends SubscriptionBaseVisitor {
    private static final MethodMatcher THREAD_START = MethodMatcher.create().typeDefinition("java.lang.Thread").name("start");
    private final Deque<Boolean> inMethodOrStaticInitializerOrFinalClass = new LinkedList<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.STATIC_INITIALIZER);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
                this.inMethodOrStaticInitializerOrFinalClass.push(((ClassTree)tree).symbol().isFinal());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.STATIC_INITIALIZER})) {
                this.inMethodOrStaticInitializerOrFinalClass.push(Boolean.TRUE);
            } else if (BooleanUtils.isFalse((Boolean)this.inMethodOrStaticInitializerOrFinalClass.peek()) && THREAD_START.matches((MethodInvocationTree)tree)) {
                this.reportIssue((Tree)MethodsHelper.methodName((MethodInvocationTree)tree), "Move this \"start\" call to another method.");
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (this.hasSemantic() && tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.STATIC_INITIALIZER})) {
            this.inMethodOrStaticInitializerOrFinalClass.pop();
        }
    }
}

