/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.maven;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.maven.helpers.MavenDependencyCollector;
import org.sonar.maven.MavenCheck;
import org.sonar.maven.MavenFileScanner;
import org.sonar.maven.MavenFileScannerContext;
import org.sonar.maven.model.LocatedAttribute;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.Dependency;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3422", name="Dependencies should not have \"system\" scope", priority=Priority.MAJOR, tags={"lock-in", "maven"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="OS_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
public class DependencyWithSystemScopeCheck
implements MavenFileScanner {
    public void scanFile(MavenFileScannerContext context) {
        List<Dependency> dependencies = new MavenDependencyCollector(context.getMavenProject()).allDependencies();
        for (Dependency dependency : dependencies) {
            LocatedAttribute scope = dependency.getScope();
            if (scope == null || !"system".equalsIgnoreCase(scope.getValue())) continue;
            context.reportIssue((MavenCheck)this, scope.startLocation().line(), "Update this scope and remove the \"systemPath\".", (List)Lists.newArrayList((Object[])new MavenFileScannerContext.Location[]{new MavenFileScannerContext.Location("Remove this", (LocatedTree)dependency.getSystemPath())}));
        }
    }
}

