/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.java.checks.methods.NameCriteria;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class MethodMatcher {
    private TypeCriteria typeDefinition;
    private TypeCriteria callSite;
    private NameCriteria methodName;
    private List<TypeCriteria> parameterTypes = Lists.newArrayList();

    MethodMatcher() {
    }

    public static MethodMatcher create() {
        return new MethodMatcher();
    }

    public MethodMatcher name(String methodName) {
        this.methodName = NameCriteria.is(methodName);
        return this;
    }

    public MethodMatcher name(NameCriteria methodName) {
        Preconditions.checkState((this.methodName == null ? 1 : 0) != 0);
        this.methodName = methodName;
        return this;
    }

    public MethodMatcher typeDefinition(TypeCriteria typeDefinition) {
        Preconditions.checkState((this.typeDefinition == null ? 1 : 0) != 0);
        this.typeDefinition = typeDefinition;
        return this;
    }

    public MethodMatcher typeDefinition(String fullyQualifiedTypeName) {
        Preconditions.checkState((this.typeDefinition == null ? 1 : 0) != 0);
        this.typeDefinition = TypeCriteria.is(fullyQualifiedTypeName);
        return this;
    }

    public MethodMatcher callSite(TypeCriteria callSite) {
        this.callSite = callSite;
        return this;
    }

    public MethodMatcher addParameter(String fullyQualifiedTypeParameterName) {
        Preconditions.checkState((this.parameterTypes != null ? 1 : 0) != 0);
        this.parameterTypes.add(TypeCriteria.is(fullyQualifiedTypeParameterName));
        return this;
    }

    public MethodMatcher addParameter(TypeCriteria parameterTypeCriteria) {
        Preconditions.checkState((this.parameterTypes != null ? 1 : 0) != 0);
        this.parameterTypes.add(parameterTypeCriteria);
        return this;
    }

    public MethodMatcher withNoParameterConstraint() {
        Preconditions.checkState((this.parameterTypes == null || this.parameterTypes.isEmpty() ? 1 : 0) != 0);
        this.parameterTypes = null;
        return this;
    }

    public boolean matches(NewClassTree newClassTree) {
        return this.matches(newClassTree.constructorSymbol(), null);
    }

    public boolean matches(MethodInvocationTree mit) {
        IdentifierTree id = MethodMatcher.getIdentifier(mit);
        return id != null && this.matches(id.symbol(), MethodMatcher.getCallSiteType(mit));
    }

    public boolean matches(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        Symbol.TypeSymbol enclosingClass = symbol.enclosingClass();
        return enclosingClass != null && this.matches((Symbol)symbol, enclosingClass.type());
    }

    private boolean matches(Symbol symbol, Type callSiteType) {
        return symbol.isMethodSymbol() && this.isSearchedMethod((Symbol.MethodSymbol)symbol, callSiteType);
    }

    private static Type getCallSiteType(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol.TypeSymbol enclosingClassSymbol = ((IdentifierTree)methodSelect).symbol().enclosingClass();
            if (enclosingClassSymbol != null) {
                return enclosingClassSymbol.type();
            }
        } else if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodSelect;
            return memberSelect.expression().symbolType();
        }
        return null;
    }

    private boolean isSearchedMethod(Symbol.MethodSymbol symbol, Type callSiteType) {
        boolean result;
        boolean bl = result = this.nameAcceptable(symbol) && this.parametersAcceptable(symbol);
        if (this.typeDefinition != null) {
            result &= this.typeDefinition.matches(symbol.owner().type());
        }
        if (this.callSite != null) {
            result &= callSiteType != null && this.callSite.matches(callSiteType);
        }
        return result;
    }

    private boolean nameAcceptable(Symbol.MethodSymbol symbol) {
        return this.methodName != null && this.methodName.matches(symbol.name());
    }

    private boolean parametersAcceptable(Symbol.MethodSymbol methodSymbol) {
        if (this.parameterTypes == null) {
            return true;
        }
        List parametersTypes = methodSymbol.parameterTypes();
        List<TypeCriteria> arguments = this.parameterTypes;
        if (parametersTypes.size() == arguments.size()) {
            int i = 0;
            for (Type parameterType : parametersTypes) {
                if (!arguments.get(i).matches(parameterType)) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private static IdentifierTree getIdentifier(MethodInvocationTree mit) {
        IdentifierTree id = null;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            id = (IdentifierTree)mit.methodSelect();
        } else if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            id = ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
        }
        return id;
    }
}

