/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2184")
public class CastArithmeticOperandCheck
extends IssuableSubscriptionVisitor {
    private static final Map<Tree.Kind, String> OPERATION_BY_KIND = ImmutableMap.builder().put((Object)Tree.Kind.PLUS, (Object)"addition").put((Object)Tree.Kind.MINUS, (Object)"substraction").put((Object)Tree.Kind.MULTIPLY, (Object)"multiplication").put((Object)Tree.Kind.DIVIDE, (Object)"division").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                AssignmentExpressionTree aet = (AssignmentExpressionTree)tree;
                Type varType = aet.symbolType();
                ExpressionTree expr = aet.expression();
                this.checkExpression(varType, expr);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                Type varType = variableTree.type().symbolType();
                ExpressionTree expr = variableTree.initializer();
                this.checkExpression(varType, expr);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.checkMethodInvocationArgument((MethodInvocationTree)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                Type returnType;
                MethodTreeImpl methodTree = (MethodTreeImpl)tree;
                Type type = returnType = methodTree.returnType() != null ? methodTree.returnType().symbolType() : null;
                if (returnType != null && CastArithmeticOperandCheck.isVarTypeErrorProne(returnType)) {
                    methodTree.accept((TreeVisitor)new ReturnStatementVisitor(returnType));
                }
            }
        }
    }

    private void checkMethodInvocationArgument(MethodInvocationTree mit) {
        Symbol symbol = mit.symbol();
        if (symbol.isMethodSymbol()) {
            List parametersTypes = ((Symbol.MethodSymbol)symbol).parameterTypes();
            if (mit.arguments().size() == parametersTypes.size()) {
                int i = 0;
                for (Type argType : parametersTypes) {
                    this.checkExpression(argType, (ExpressionTree)mit.arguments().get(i));
                    ++i;
                }
            }
        }
    }

    private void checkExpression(Type varType, @Nullable ExpressionTree expr) {
        if (CastArithmeticOperandCheck.isVarTypeErrorProne(varType) && expr != null && CastArithmeticOperandCheck.expressionIsOperationToInt(expr)) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)expr;
            if (binaryExpressionTree.is(new Tree.Kind[]{Tree.Kind.DIVIDE}) && varType.isPrimitive(Type.Primitives.LONG)) {
                return;
            }
            this.reportIssue((Tree)binaryExpressionTree.operatorToken(), "Cast one of the operands of this " + OPERATION_BY_KIND.get(expr.kind()) + " operation to a \"" + varType.name() + "\".");
        }
    }

    private static boolean expressionIsOperationToInt(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.PLUS, Tree.Kind.MINUS}) && expr.symbolType().isPrimitive(Type.Primitives.INT);
    }

    private static boolean isVarTypeErrorProne(Type varType) {
        return varType.isPrimitive(Type.Primitives.LONG) || varType.isPrimitive(Type.Primitives.FLOAT) || varType.isPrimitive(Type.Primitives.DOUBLE);
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private Type returnType;

        public ReturnStatementVisitor(Type returnType) {
            this.returnType = returnType;
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            CastArithmeticOperandCheck.this.checkExpression(this.returnType, tree.expression());
        }
    }
}

