/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2200")
public class CompareToResultTestCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryExpression = (BinaryExpressionTree)tree;
        if (this.isInvalidTest(binaryExpression.leftOperand(), binaryExpression.rightOperand())) {
            this.reportIssue((Tree)binaryExpression.operatorToken(), "Only the sign of the result should be examined.");
        }
    }

    private boolean isInvalidTest(ExpressionTree operand1, ExpressionTree operand2) {
        return CompareToResultTestCheck.isNonZeroInt(operand1) && this.isCompareToResult(operand2) || CompareToResultTestCheck.isNonZeroInt(operand2) && this.isCompareToResult(operand1);
    }

    private boolean isCompareToResult(ExpressionTree expression) {
        if (this.hasSemantic()) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return CompareToResultTestCheck.isCompareToInvocation((MethodInvocationTree)expression);
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return CompareToResultTestCheck.isIdentifierContainingCompareToResult((IdentifierTree)expression);
            }
        }
        return false;
    }

    private static boolean isCompareToInvocation(MethodInvocationTree invocation) {
        Symbol method = invocation.symbol();
        if ("compareTo".equals(method.name()) && invocation.arguments().size() == 1) {
            return method.owner().enclosingClass().type().isSubtypeOf("java.lang.Comparable");
        }
        return false;
    }

    private static boolean isIdentifierContainingCompareToResult(IdentifierTree identifier) {
        ExpressionTree initializer;
        Symbol variableSymbol = identifier.symbol();
        if (!variableSymbol.isVariableSymbol()) {
            return false;
        }
        VariableTree variableDefinition = ((Symbol.VariableSymbol)variableSymbol).declaration();
        if (variableDefinition != null && (initializer = variableDefinition.initializer()) != null && initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && variableSymbol.owner().isMethodSymbol()) {
            MethodTree method = ((Symbol.MethodSymbol)variableSymbol.owner()).declaration();
            return method != null && CompareToResultTestCheck.isCompareToInvocation((MethodInvocationTree)initializer) && !CompareToResultTestCheck.isReassigned(variableSymbol, (Tree)method);
        }
        return false;
    }

    private static boolean isNonZeroInt(ExpressionTree expression) {
        return CompareToResultTestCheck.isNonZeroIntLiteral(expression) || expression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) && CompareToResultTestCheck.isNonZeroIntLiteral(((UnaryExpressionTree)expression).expression());
    }

    private static boolean isNonZeroIntLiteral(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && !"0".equals(((LiteralTree)expression).value());
    }

    private static boolean isReassigned(Symbol variableSymbol, Tree method) {
        List usages = variableSymbol.usages();
        ReAssignmentFinder reAssignmentFinder = new ReAssignmentFinder(usages);
        method.accept((TreeVisitor)reAssignmentFinder);
        return reAssignmentFinder.foundReAssignment;
    }

    private static class ReAssignmentFinder
    extends BaseTreeVisitor {
        private final Collection<IdentifierTree> usages;
        private boolean foundReAssignment = false;

        public ReAssignmentFinder(Collection<IdentifierTree> usages) {
            this.usages = usages;
        }

        public void visitUnaryExpression(UnaryExpressionTree unaryExp) {
            if (unaryExp.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT})) {
                this.checkReAssignment(unaryExp.expression());
            }
            super.visitUnaryExpression(unaryExp);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree assignmentExpression) {
            this.checkReAssignment(assignmentExpression.variable());
            super.visitAssignmentExpression(assignmentExpression);
        }

        private void checkReAssignment(ExpressionTree expression) {
            IdentifierTree identifier;
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.usages.contains(identifier = (IdentifierTree)expression)) {
                this.foundReAssignment = true;
            }
        }
    }
}

