/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2177")
public class ConfusingOverloadCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> SERIALIZATION_METHOD_NAME = Sets.newHashSet((Object[])new String[]{"writeObject", "readObject", "readObjectNoData", "writeReplace", "readResolve"});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        Symbol.MethodSymbol methodSymbol;
        Symbol.TypeSymbol owner;
        Type superClass;
        if (!this.hasSemantic()) {
            return;
        }
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        if (BooleanUtils.isFalse((Boolean)methodTree.isOverriding()) && (superClass = (owner = (Symbol.TypeSymbol)(methodSymbol = methodTree.symbol()).owner()).superClass()) != null && !SERIALIZATION_METHOD_NAME.contains(methodSymbol.name())) {
            boolean reportStaticIssue = this.checkMethod((Tree)methodTree.simpleName(), methodSymbol, superClass);
            superClass = superClass.symbol().superClass();
            while (superClass != null && !reportStaticIssue) {
                reportStaticIssue = this.checkStaticMethod((Tree)methodTree.simpleName(), methodSymbol, superClass);
                superClass = superClass.symbol().superClass();
            }
        }
    }

    private boolean checkStaticMethod(Tree reportTree, Symbol.MethodSymbol methodSymbol, Type superClass) {
        for (Symbol methodWithSameName : superClass.symbol().lookupSymbols(methodSymbol.name())) {
            if (!methodWithSameName.isMethodSymbol() || !ConfusingOverloadCheck.hideStaticMethod(methodSymbol, superClass, methodWithSameName)) continue;
            this.reportIssue(reportTree, "Rename this method or make it \"static\".");
            return true;
        }
        return false;
    }

    private boolean checkMethod(Tree reportTree, Symbol.MethodSymbol methodSymbol, Type superClass) {
        boolean reportStaticIssue = false;
        for (Symbol methodWithSameName : superClass.symbol().lookupSymbols(methodSymbol.name())) {
            if (!methodWithSameName.isMethodSymbol()) continue;
            if (ConfusingOverloadCheck.hideStaticMethod(methodSymbol, superClass, methodWithSameName)) {
                this.reportIssue(reportTree, "Rename this method or make it \"static\".");
                reportStaticIssue = true;
                continue;
            }
            if (!ConfusingOverloadCheck.confusingOverload(methodSymbol, (Symbol.MethodSymbol)methodWithSameName)) continue;
            this.reportIssue(reportTree, ConfusingOverloadCheck.getMessage(methodWithSameName));
        }
        return reportStaticIssue;
    }

    private static String getMessage(Symbol methodWithSameName) {
        String message = "Rename this method or correct the type of the argument(s) to override the parent class method.";
        if (methodWithSameName.isPrivate()) {
            message = "Rename this method; there is a \"private\" method in the parent class with the same name.";
        }
        return message;
    }

    private static boolean hideStaticMethod(Symbol.MethodSymbol methodSymbol, Type superClass, Symbol symbolWithSameName) {
        return symbolWithSameName.isStatic() && !methodSymbol.isStatic() && ((JavaSymbol.MethodJavaSymbol)methodSymbol).checkOverridingParameters((JavaSymbol.MethodJavaSymbol)symbolWithSameName, (ClassJavaType)superClass) != false;
    }

    private static boolean confusingOverload(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodWithSameName) {
        if (methodSymbol.isStatic()) {
            return false;
        }
        List argTypes = methodSymbol.parameterTypes();
        List parameterTypes = methodWithSameName.parameterTypes();
        if (argTypes.size() != parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < argTypes.size(); ++i) {
            if (((Type)argTypes.get(i)).name().equals(((Type)parameterTypes.get(i)).name())) continue;
            return false;
        }
        return true;
    }
}

