/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2272")
public class IteratorNextExceptionCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher NEXT_INVOCATION_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.Iterator")).name("next").withoutParameter();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && IteratorNextExceptionCheck.isIteratorNextMethod(methodTree.symbol()) && methodTree.block() != null) {
            NextMethodBodyVisitor visitor = new NextMethodBodyVisitor();
            tree.accept((TreeVisitor)visitor);
            if (!visitor.foundThrow) {
                this.reportIssue((Tree)methodTree.simpleName(), "Add a \"NoSuchElementException\" for iteration beyond the end of the collection.");
            }
        }
    }

    private static boolean isIteratorNextMethod(Symbol.MethodSymbol symbol) {
        return "next".equals(symbol.name()) && symbol.parameterTypes().isEmpty() && IteratorNextExceptionCheck.isIterator(symbol.enclosingClass());
    }

    private static boolean isIterator(Symbol.TypeSymbol typeSymbol) {
        return typeSymbol.type().isSubtypeOf("java.util.Iterator");
    }

    private static class NextMethodBodyVisitor
    extends BaseTreeVisitor {
        private boolean foundThrow = false;

        private NextMethodBodyVisitor() {
        }

        public void visitThrowStatement(ThrowStatementTree throwStatementTree) {
            NewClassTree newClassTree;
            ExpressionTree expression = throwStatementTree.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && (newClassTree = (NewClassTree)expression).symbolType().is("java.util.NoSuchElementException")) {
                this.foundThrow = true;
            }
            super.visitThrowStatement(throwStatementTree);
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (NEXT_INVOCATION_MATCHER.matches(methodInvocation) || this.throwsNoSuchElementException(methodInvocation)) {
                this.foundThrow = true;
            }
            super.visitMethodInvocation(methodInvocation);
        }

        public boolean throwsNoSuchElementException(MethodInvocationTree methodInvocationTree) {
            Symbol symbol = methodInvocationTree.symbol();
            if (!symbol.isMethodSymbol()) {
                return false;
            }
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            for (Type thrownType : methodSymbol.thrownTypes()) {
                if (!thrownType.is("java.util.NoSuchElementException")) continue;
                return true;
            }
            return false;
        }
    }
}

