/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2653")
public class MainInServletCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> SERVLET_AND_EJB_CLASSES = ImmutableSet.of((Object)"javax.servlet.http.HttpServlet", (Object)"org.apache.struts.action.Action", (Object)"javax.ejb.EnterpriseBean");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree node = (ClassTree)tree;
        Symbol.TypeSymbol symbol = node.symbol();
        if (MainInServletCheck.isServletOrEjb((Symbol)symbol)) {
            for (Tree member : node.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !((MethodTreeImpl)member).isMainMethod()) continue;
                this.reportIssue((Tree)((MethodTree)member).simpleName(), "Remove this unwanted \"main\" method.");
            }
        }
    }

    private static boolean isServletOrEjb(Symbol symbol) {
        if (SERVLET_AND_EJB_CLASSES.stream().anyMatch(arg_0 -> ((Type)symbol.type()).isSubtypeOf(arg_0))) {
            return true;
        }
        return symbol.metadata().annotations().stream().anyMatch(annotation -> annotation.symbol().type().fullyQualifiedName().startsWith("javax.ejb."));
    }
}

