/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1148")
public class PrintStackTraceCalledWithoutArgumentCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Deque<Symbol.TypeSymbol> enclosingClass = new LinkedList<Symbol.TypeSymbol>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        Symbol.TypeSymbol enclosingSymbol = tree.symbol();
        this.enclosingClass.push(enclosingSymbol);
        super.visitClass(tree);
        this.enclosingClass.pop();
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        super.visitMethodInvocation(tree);
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)tree.methodSelect();
            IdentifierTree identifierTree = memberSelectExpressionTree.identifier();
            if (!this.enclosingClassExtendsThrowable() && "printStackTrace".equals(identifierTree.name()) && PrintStackTraceCalledWithoutArgumentCheck.calledOnTypeInheritedFromThrowable(memberSelectExpressionTree.expression()) && tree.arguments().isEmpty()) {
                this.context.reportIssue((JavaCheck)this, (Tree)identifierTree, "Use a logger to log this exception.");
            }
        }
    }

    private boolean enclosingClassExtendsThrowable() {
        return this.enclosingClass.peek() != null && this.enclosingClass.peek().type().isSubtypeOf("java.lang.Throwable");
    }

    private static boolean calledOnTypeInheritedFromThrowable(ExpressionTree tree) {
        return tree.symbolType().isSubtypeOf("java.lang.Throwable");
    }
}

